/*****************************************************************/
/*  University of Nebraska-Lincoln                               */
/*  Department of Electrical Engineering                         */
/*  Bioinformatics Group                                         */
/*  Sam Way                                                      */
/*  1/1/2012                                                     */
/*****************************************************************/

#ifndef PARMS_H
#define PARMS_H

/******************************************************************/
/* Public Module Constants                                        */
/******************************************************************/
/******************************************************************/
/* Public Type Definitions                                        */
/******************************************************************/
/******************************************************************/
/* Public Module Variables */
/******************************************************************/
/******************************************************************/
/* Public Module Function Prototypes */
/******************************************************************/
void            PARMS_Initialize(void); 
BOOLEAN         PARMS_ProcessCommandLine(INT argc, BYTE **argv); 
string          PARMS_GetInputFileName(ULONG i); 
vector<string> *PARMS_GetInputFileNames(void);
ULONG           PARMS_GetInputFileCount(void); 
string          PARMS_GetOutputFileName(void);
BOOLEAN         PARMS_DidSupplyDisplaySettingsFile(void);
string          PARMS_GetDisplaySettingsFileName(void); 
BOOLEAN         PARMS_DidSupplyFastaFile(void);
string          PARMS_GetFastaFileName(void); 
BOOLEAN         PARMS_DidSupplyColorFile(void);
string          PARMS_GetColorFileName(void); 
BOOLEAN         PARMS_DidSupplyLabelFile(void);
string          PARMS_GetLabelFileName(void); 
void            PARMS_GetNextColor(UBYTE *r, UBYTE *g, UBYTE *b, UBYTE *a); 
void            PARMS_Error(BYTE *String);
string          PARMS_Trim( const string& s );
void            PARMS_GetStringParts(string originalString, 
                                     vector<string> *stringParts, 
                                     string delimiter); 

#endif // PARMS_H

/********************************* END OF FILE ***********************************/
