/*****************************************************************/
/*  University of Nebraska-Lincoln                               */
/*  Department of Electrical Engineering                         */
/*  Bioinformatics Group                                         */
/*  Sam Way                                                      */
/*  1/1/2012                                                     */
/*****************************************************************/

/*********************************************************************************/
/* Included Header Files */
/*********************************************************************************/
#include "Globals.h"
#include "Parms.h"
#include "DistanceMatrix.h"
#include "nSpectVisualizer.h"

using namespace std;

/*********************************************************************************/
/* Private Module Constants */
/*********************************************************************************/
/*********************************************************************************/
/* Private Type Definitions */
/*********************************************************************************/
/*********************************************************************************/
/* Private Module Function Prototypes */
/*********************************************************************************/
INT  main(INT argc, BYTE **argv); 

/*********************************************************************************/
/* Private Module Variables */
/*********************************************************************************/
/*********************************************************************************/
/* Public and Private Module Functions */
/*********************************************************************************/

INT main(INT argc, BYTE **argv) 
{    
    nSpectVisualizer Visualizer; 
    BOOLEAN okToRun = TRUE; 
    
    srand (time(NULL));
    PARMS_Initialize(); 
    okToRun = PARMS_ProcessCommandLine(argc, argv); 
    
    if (okToRun)
    {
        okToRun = Visualizer.Initialize(argc, argv); 
        
        if (okToRun)
        {
            cout << "Starting visualization!" << endl;
            Visualizer.StartVisualization(); 
        }
        else
        {
            cout << "One or more problems encountered during "
                 << "initialization!\nExiting program." << endl;
        }
    }
    
    return 0;
}
