/*****************************************************************/
/*  University of Nebraska-Lincoln                               */
/*  Department of Electrical Engineering                         */
/*  Bioinformatics Group                                         */
/*  Sam Way                                                      */
/*  1/1/2012                                                     */
/*****************************************************************/

#ifndef NSPECT_VISUALIZER_H
#define NSPECT_VISUALIZER_H

#include "DistanceMatrix.h"
#include "nSpectDisplayThread.h"
#include "nSpectUpdateThread.h"
#include "nSpectSecondaryUpdateThread.h"

/*********************************************************************************/
/* Private Module Constants */
/*********************************************************************************/
#define OUTPUT_DIM 3
#define COLOR_SIZE 4
#define MAX_DIST   100.0

/*********************************************************************************/
/* Class Defintion                                                               */
/*********************************************************************************/
typedef enum SIZE
{
    XSMALL = 1,
    SMALL  = 2,
    MEDIUM = 3,
    LARGE  = 4,
    XLARGE = 5
} SIZE; 

typedef enum SHAPE 
{ 
    SPHERE, 
    CUBE, 
    PYRAMID, 
    DIAMOND 
} SHAPE; 

struct nSpectDisplayObject 
{
    string  Name; 
    ULONG   Index; 
    DOUBLE *DistanceVector; 
    DOUBLE  Location[OUTPUT_DIM]; 
    DOUBLE  Velocity[OUTPUT_DIM]; 
    DOUBLE  Force[OUTPUT_DIM]; 
    UBYTE   ColorRGBA[COLOR_SIZE]; 
    SHAPE   Shape; 
    SIZE    Size; 
    BOOLEAN Active; 
}; 

typedef vector<nSpectDisplayObject> nSpectDisplayObjectCollection;

class nSpectVisualizer
{
    public:
        nSpectVisualizer(); 
        ~nSpectVisualizer(); 
        
        // Public Functions
        BOOLEAN Initialize(INT argc, BYTE **argv);
        void GetClearColor(DOUBLE *clear); 
        void StartVisualization(void);  
        void RestartVisualization(void);
        void PlayPauseVisualization(void); 
        void ShakeVisualization(void);
        void ExportDistances(void);
        void ActivateAll(void); 
        void DecreaseScale(void); 
        void IncreaseScale(void); 
        void SwapMatrices(void);
        DOUBLE GetMaxSeparation(void); 
        BOOLEAN IsUpdateThreadActive(void); 
    
        // Public Variables
        nSpectDisplayObjectCollection ObjectCollection; 
        DistanceMatrix *Matrix; 
        DistanceMatrix *SecondaryMatrix; 
    
    private:
        // Private Functions 
        BOOLEAN LoadDistanceMatrix(void); 
        BOOLEAN LoadColorFile(void); 
        BOOLEAN LoadLabelFile(void); 
        BOOLEAN LoadDisplaySettingsFile(void); 
    
        // Private Variables 
        nSpectUpdateThread UpdateThread;    
        nSpectSecondaryUpdateThread SecondaryUpdateThread; 
        nSpectDisplayThread DisplayThread;
}; 

#endif // NSPECT_VISUALIZER_H

/********************************* END OF FILE ***********************************/
