/*****************************************************************/
/*  University of Nebraska-Lincoln                               */
/*  Department of Electrical Engineering                         */
/*  Bioinformatics Group                                         */
/*  Sam Way                                                      */
/*  1/1/2012                                                     */
/*****************************************************************/

#ifndef NSPECT_UPDATE_THREAD_H
#define NSPECT_UPDATE_THREAD_H

/*********************************************************************************/
/* Public Module Constants                                                       */
/*********************************************************************************/

/*********************************************************************************/
/* Forward Declaration                                                           */
/*********************************************************************************/
class nSpectVisualizer; 

/*********************************************************************************/
/* Class Defintion                                                               */
/*********************************************************************************/

class nSpectUpdateThread
{
    public:
        nSpectUpdateThread(); 
        ~nSpectUpdateThread(); 
        
        // Public Functions
        void    Initialize(nSpectVisualizer *visualizer);
        void    StartThread(void);
        void    PauseThread(void);
        void    UnpauseThread(void);
        void    PlayPauseVisualization(void); 
        void    StopThread(void);
        void    RestartVisualization(void);
        void    ShakeVisualization(void); 
        void    DecreaseScale(void); 
        void    IncreaseScale(void); 
      DOUBLE    GetMaxSeparation(void); 
     BOOLEAN    IsActive(void);
    
    private: 
        // Private Functions
        void    RandomizeLocations(void);
        void    ExportDistances(void); 
}; 

#endif

/********************************* END OF FILE ***********************************/
