/*****************************************************************/
/*  University of Nebraska-Lincoln                               */
/*  Department of Electrical Engineering                         */
/*  Bioinformatics Group                                         */
/*  Sam Way                                                      */
/*  1/1/2012                                                     */
/*****************************************************************/

#ifndef DISTANCE_MATRIX_H
#define DISTANCE_MATRIX_H

/*********************************************************************************/
/* Private Module Constants                                                      */
/*********************************************************************************/

/*********************************************************************************/
/* Class Defintion                                                               */
/*********************************************************************************/
class DistanceMatrix 
{
    public:
        DistanceMatrix(); 
        ~DistanceMatrix(); 

        // Public Functions 
        void   Clear(void); 
        void   ReadFromFile(string filename); 
        void   Rescale(void);
        DOUBLE at(ULONG i, ULONG j); 
        DOUBLE *Row(ULONG i); 
        ULONG  GetDimension(void); 
    
    private: 
        DOUBLE **Matrix; 
        ULONG  Dimension; 
}; 

#endif // PROBABILITY_MODEL_H

/********************************* END OF FILE ***********************************/
