/*****************************************************************/
/*  University of Nebraska-Lincoln                               */
/*  Department of Electrical Engineering                         */
/*  Bioinformatics Group                                         */
/*  Sam Way                                                      */
/*  2/12/10                                                      */
/*****************************************************************/

#ifndef PROFILER_H
#define PROFILER_H

/*********************************************************************************/
/* Included Header Files                                                         */
/*********************************************************************************/
#include "globals.h"
#include <QHash>
#include <QObject>
#include <QTextStream>

/*********************************************************************************/
/* Class Definition                                                              */
/*********************************************************************************/
class Profiler : public QObject
{
public:
    Profiler();
    QString ProfileFastaFile(QString filename, INT wordLength, QList<Sequence>* list, BOOLEAN normalize);
    void    PrepareVector(DOUBLE* vector, INT vectorSize, INT wordLength);
    BOOLEAN ProfileNextSequence(QTextStream *inStream, Sequence *tempSequence, INT wordLength, SequenceCounts *tempCounts);

    QHash<QString, INT> m_hash;
};

#endif // PROFILER_H

/********************************* END OF FILE ***********************************/
