/*****************************************************************/
/*  University of Nebraska-Lincoln                               */
/*  Department of Electrical Engineering                         */
/*  Bioinformatics Group                                         */
/*  Sam Way                                                      */
/*  2/12/10                                                      */
/*****************************************************************/

#ifndef PROCESSINGTHREAD_H
#define PROCESSINGTHREAD_H

/*********************************************************************************/
/* Included Header Files                                                         */
/*********************************************************************************/
#include "globals.h"
#include "fragmentclassifier.h"
#include "classifierdatabase.h"
#include "mainwindow.h"
#include <QMutex>
#include <QThread>
#include <QWaitCondition>
#include <QQueue>

/*********************************************************************************/
/* Class Definition                                                              */
/*********************************************************************************/

struct ScheduledProcess
{
    QStringList inFilenames;
    QString outFilename;
};

/*********************************************************************************/

class ProcessingThread : public QThread
{

    Q_OBJECT

public:
    ProcessingThread(MainWindow *userWindow, QObject *parent = 0);
    ~ProcessingThread();

public slots:
    void ClassifyFiles(QStringList inFilenames, QString outFilename, INT classificationThreshold, BOOLEAN updateDatabase);
    void ReadDatabaseFile(QString filename);
    void CreateDatabaseFile(QStringList* inFilenames, QString* outFilename, INT wordLength);
    void AddItemsToDatabase(QStringList inFilenames);

protected:
    void run();

private:
    QQueue<ScheduledProcess> m_processQueue;
    QWaitCondition m_filesToProcess;
    QMutex m_mutex;
    BOOLEAN m_abort;
    FragmentClassifier m_classifier;
    ClassifierDatabase m_database;   

    BOOLEAN UpdateDatabase(QString outFilename);

signals:
    void AlertUser(QString message);
    void ValidDB(BOOLEAN valid);

};

#endif // PROCESSINGTHREAD_H

/********************************* END OF FILE ***********************************/
