/*****************************************************************/
/*  University of Nebraska-Lincoln                               */
/*  Department of Electrical Engineering                         */
/*  Bioinformatics Group                                         */
/*  Sam Way                                                      */
/*  2/12/10                                                      */
/*****************************************************************/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

/*********************************************************************************/
/* Included Header Files                                                         */
/*********************************************************************************/
#include "globals.h"
#include "ui_mainwindow.h"
#include <QMainWindow>
#include <QDir>
#include <QtGui>

/*********************************************************************************/
/* Class Definition                                                              */
/*********************************************************************************/

namespace Ui
{
    class MainWindow;
}

class MainWindow : public QMainWindow,
                   private Ui::MainWindow
{

    Q_OBJECT

public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

protected:
    void changeEvent(QEvent *e);

private:
    BOOLEAN m_valid;
    INT m_classificationThreshold;
    QString m_selectedFile;
    QStringList m_selectedFiles;
    QFileDialog m_fileChooser;

    void setupActions();
    void open(BOOLEAN update);

protected slots:
    void about();
    void Classify();
    void ClassifyAndUpdate();
    void NewDatabaseFile();
    void AddDatbaseItems();
    void SetDatabaseFile();
    void SetValidDB(BOOLEAN valid);
    void DisplayStatus(QString status);
    void DisplayMessage(QString msg);
    void SetClassifyThreshold();

signals:
    void Process(QString filename);
    void ReadDatabaseFile(QString filename);
    void ClassifyFiles(QStringList inFilenames, QString outFilename, INT classficationThreshold, BOOLEAN update);
    void CreateDatabaseFile(QStringList* inFilenames, QString* outFilename, INT wordLength);
    void AddItemsToDatabase(QStringList inFilenames);
};

#endif // MAINWINDOW_H

/********************************* END OF FILE ***********************************/
