/*****************************************************************/
/*  University of Nebraska-Lincoln                               */
/*  Department of Electrical Engineering                         */
/*  Bioinformatics Group                                         */
/*  Sam Way                                                      */
/*  2/12/10                                                      */
/*****************************************************************/

/*********************************************************************************/
/* Included Header Files                                                         */
/*********************************************************************************/
#include "mainwindow.h"
#include "processingthread.h"
#include <QtGui/QApplication>
#include <QMetaType>

/*********************************************************************************/
/* Program Main                                                                  */
/*********************************************************************************/
int main(int argc, char *argv[])
{
    QApplication a(argc, argv);
    MainWindow w;
    ProcessingThread* processThread;
    
    w.show();
    processThread = new ProcessingThread(&w);

    qRegisterMetaType<INT>("INT");
    qRegisterMetaType<BOOLEAN>("BOOLEAN");

    QObject::connect(&w,            SIGNAL(CreateDatabaseFile(QStringList*,QString*,INT)),
                     processThread, SLOT(CreateDatabaseFile(QStringList*,QString*,INT)), Qt::QueuedConnection);
    QObject::connect(&w,            SIGNAL(ReadDatabaseFile(QString)), processThread, SLOT(ReadDatabaseFile(QString)), Qt::QueuedConnection);
    QObject::connect(&w,            SIGNAL(ClassifyFiles(QStringList,QString,INT,BOOLEAN)),
                     processThread, SLOT(ClassifyFiles(QStringList,QString,INT,BOOLEAN)), Qt::QueuedConnection);
    QObject::connect(&w, SIGNAL(AddItemsToDatabase(QStringList)), processThread, SLOT(AddItemsToDatabase(QStringList)));
    QObject::connect(processThread, SIGNAL(AlertUser(QString)), &w, SLOT(DisplayMessage(QString)), Qt::QueuedConnection);
    QObject::connect(processThread, SIGNAL(ValidDB(BOOLEAN)), &w, SLOT(SetValidDB(BOOLEAN)), Qt::QueuedConnection);

    return a.exec();
}

/********************************* END OF FILE ***********************************/
