/*****************************************************************/
/*  University of Nebraska-Lincoln                               */
/*  Department of Electrical Engineering                         */
/*  Bioinformatics Group                                         */
/*  Sam Way                                                      */
/*  2/12/10                                                      */
/*****************************************************************/

#ifndef CLASSIFIERDATABASE_H
#define CLASSIFIERDATABASE_H

/*********************************************************************************/
/* Included Header Files                                                         */
/*********************************************************************************/
#include "globals.h"
#include "profiler.h"
#include <QObject>
#include <QList>

/*********************************************************************************/
/* Class Defintion                                                               */
/*********************************************************************************/

class ClassifierDatabase : public QObject
{

Q_OBJECT

public:
    ClassifierDatabase();
    BOOLEAN IsValid();
    INT WordLength();
    INT GetIndex(QString modelName);
    void ReadDatabase(QString filename);
    void CreateDatabase(QStringList* inFileNames, QString* outFilename, INT wordLength);
    BOOLEAN SaveDatabase();
    BOOLEAN UpdateDatabase(QString outFilename);
    void UpdateVector(INT vectorIndex, DOUBLE *tempVector);
    void AddItems(QStringList inFileNames);

    QList<Sequence> m_items;

private:
    QString  m_filename;
    BOOLEAN  m_isValid;
    INT      m_updateCount;
    INT      m_wordLength;
    Profiler m_profiler;

    BOOLEAN UpdateVector(INT vectorIndex, DOUBLE *tempVector, INT vectorLength, QString outputFilename);

signals:
    void AlertUser(QString message);
    void AlertStatus(QString status);

};

#endif // CLASSIFIERDATABASE_H

/********************************* END OF FILE ***********************************/
