/*****************************************************************/
/*  University of Nebraska-Lincoln                               */
/*  Department of Electrical Engineering                         */
/*  Bioinformatics Group                                         */
/*  Sam Way                                                      */
/*  2/12/10                                                      */
/*****************************************************************/

#ifndef GLOBALS_H
#define GLOBALS_H

/******************************************************************/
/* Included Header Files                                          */
/******************************************************************/
#include <QString>
#include <QList>
#include "stdlib.h"
#include "math.h"

/******************************************************************/
/* Public Module Constants                                        */
/******************************************************************/
#define NUM_BASES               4                 // A, G, C, T
#define DEFAULT_OLIGMER_SIZE    7
#define SEPARATOR               ":"
#define HEADER_WORD_LENGTH      "%WORD_LENGTH"
#define ZERO_ENTRY_VALUE        -20
#define DB_MAX_UPDATES          2
#define UPDATE_THRESHOLD        250000

#define BASE_VALUE_A            0
#define BASE_VALUE_G            1
#define BASE_VALUE_C            2
#define BASE_VALUE_T            3

#define VERSION_MAJOR           1
#define VERSION_MINOR           0
#define VERSION_REVISION        0
#define VERSION_DATE            "10/1/10"
#define APP_NAME                "RAIphy"
#define WEBSITE                 "http://bioinfo.unl.edu/raiphy.php"

/******************************************************************/
/* Public Type Definitions                                        */
/******************************************************************/
typedef char            BYTE;
typedef unsigned char   UBYTE;

typedef short           SHORT;
typedef unsigned short  USHORT;

typedef long            LONG;
typedef unsigned long   ULONG;

typedef float           FLOAT;
typedef double          DOUBLE;

typedef int             INT;
typedef unsigned int    UINT;
typedef bool            BOOLEAN;

struct Sequence
{
    QString sequenceName;
    QList<DOUBLE> sequenceVector;
    ULONG sequenceLength;
};

struct SequenceCounts
{
    QList<INT> nonzeroIndex;
    QList<INT> nonzeroCount;
};

/*********************************************************************************/
/* Public Module Variables */
/*********************************************************************************/
/*********************************************************************************/
/* Public Module Function Prototypes */
/*********************************************************************************/

#endif // GLOBALS_H

/********************************* END OF FILE ***********************************/
