/*****************************************************************/
/*  University of Nebraska-Lincoln                               */
/*  Department of Electrical Engineering                         */
/*  Bioinformatics Group                                         */
/*  Sam Way                                                      */
/*  2/12/10                                                      */
/*****************************************************************/

#ifndef FRAGMENTCLASSIFIER_H
#define FRAGMENTCLASSIFIER_H

/*********************************************************************************/
/* Included Header Files                                                         */
/*********************************************************************************/
#include "globals.h"
#include "classifierdatabase.h"
#include "profiler.h"
#include <QObject>
#include <QHash>
#include <QStringList>

/*********************************************************************************/
/* Class Definition                                                              */
/*********************************************************************************/

class FragmentClassifier : public QObject
{

    Q_OBJECT

public:
    FragmentClassifier();
    INT ClassifySequence ( ClassifierDatabase *database, SequenceCounts* tempCounts, DOUBLE *matchScore);
    BOOLEAN ClassifyFiles ( ClassifierDatabase *database,
                            QStringList inFilenames,
                            QString outFilename,
                            INT classificationThreshold);
    BOOLEAN ClassifyFilesAndUpdateDatabase ( ClassifierDatabase *database,
                                             QStringList inFilenames,
                                             QString outFilename,
                                             INT* updatedCounts,
                                             DOUBLE** updatedDatabase );

private:
    Profiler m_profiler;

    void CleanOutput(QString outputFilename, DOUBLE* bestScores, ClassifierDatabase* database, INT classificationThreshold);

signals:
    void AlertUser(QString message);
    void AlertStatus(QString status);
};

#endif // FRAGMENTCLASSIFIER_H

/********************************* END OF FILE ***********************************/

