/*****************************************************************/
/*  University of Nebraska-Lincoln                               */
/*  Department of Electrical Engineering                         */
/*  David J. Russell                                             */
/*****************************************************************/

#define _RCM

/*********************************************************************************/
/* Included Header Files */
/*********************************************************************************/
#include "Globals.h"
#include "RCM.h"
#include "StringADT.h"
#include "StringListADT.h"
#include "SparseMatrixFloatADT.h"
#include "FileIO.h"
#include "Gram.h"
#include "Parameters.h"

/*********************************************************************************/
/* Private Module Constants */
/*********************************************************************************/

/*********************************************************************************/
/* Private Type Definitions */
/*********************************************************************************/

/*********************************************************************************/
/* Private Module Function Prototypes */
/*********************************************************************************/

/*********************************************************************************/
/* Private Module Variables */
/*********************************************************************************/

/*********************************************************************************/
/* Public and Private Module Functions */
/*********************************************************************************/

INT main(INT argc, BYTE **argv)
{
   STRINGLISTADT_STRINGLIST_TYPE Sequences;
   STRINGLISTADT_STRINGLIST_TYPE MergedAlphabetSequences;
   STRINGLISTADT_STRINGLIST_TYPE HeaderLines;
   SMF_ADT_MATRIX_TYPE DistanceMatrix;

   if (PARMS_ProcessCommandLine(argc, argv) == TRUE)
   {
      STRINGLISTADT_InitializeStringList(&Sequences);
      STRINGLISTADT_InitializeStringList(&MergedAlphabetSequences);
      STRINGLISTADT_InitializeStringList(&HeaderLines);
      SMF_ADT_InitializeMatrix(&DistanceMatrix);

      srand((int) time(NULL));
      
      FILEIO_ReadFASTASequences(&Sequences, &MergedAlphabetSequences, &HeaderLines);

      if (Sequences.NumberOfStrings > 1)
      {
         PARMS_Printf("Calculating grammar-based distances.\n");
         if (PARMS_GetUseMergedAlphabetForDistance() == TRUE)
         {
            GRAM_CalculateDistances(&MergedAlphabetSequences, &DistanceMatrix);
         }
         else
         {
            GRAM_CalculateDistances(&Sequences, &DistanceMatrix);
         }

         FILEIO_WriteDistanceMatrix(&DistanceMatrix);

         PARMS_Printf("Done.\n");
      }
      else
      {
         printf("Input file was either invalid or only contained 1 sequence.\n");
      }
      
      STRINGLISTADT_CleanUpStringList(&Sequences);
      STRINGLISTADT_CleanUpStringList(&MergedAlphabetSequences);
      STRINGLISTADT_CleanUpStringList(&HeaderLines);
      SMF_ADT_CleanUpMatrix(&DistanceMatrix);
   }
   
   return 0;
}

