/*****************************************************************/
/*  University of Nebraska-Lincoln                               */
/*  Department of Electrical Engineering                         */
/*  David J. Russell                                             */
/*****************************************************************/

#ifdef _PARMS
#define PARMS_EXTERN
#else
#define PARMS_EXTERN extern
#endif

/*********************************************************************************/
/* Public Module Constants */
/*********************************************************************************/

/*********************************************************************************/
/* Public Type Definitions */
/*********************************************************************************/
typedef enum
{
   PARMS_INPUT_SEQUENCE_AUTO_DETECT,
   PARMS_INPUT_SEQUENCE_DNA_RNA,
   PARMS_INPUT_SEQUENCE_AMINO_ACID,
} PARMS_INPUT_FILE_FORMAT;

typedef enum
{
   PARMS_SEQUENCE_DNA,
   PARMS_SEQUENCE_AMINO_ACID
} PARMS_SEQUENCE_TYPE;

typedef enum
{
   PARMS_AA_MERGING_NONE,
   PARMS_AA_MERGING_DISTANCE,
} PARMS_AA_MERGING;

/*********************************************************************************/
/* Public Module Variables */
/*********************************************************************************/
#ifdef _PARMS
/*
   A,S,T,X
   B,D,N
   C
   E,K,Q,R,Z
   F
   G
   H
   I,L,M,V
   P
   W
   Y
*/
PARMS_EXTERN const BYTE PARMS_MergedAlphabetLookup[ALPHABETIC_CHARACTERS] =
{
   'A',
   'B',
   'C',
   'B',
   'E',
   'F',
   'G',
   'H',
   'I',
   'A',  /* Unknown -- X is unknown A.A. */
   'E',
   'I',
   'I',
   'B',
   'A',  /* Unknown -- X is unknown A.A. */
   'P',
   'E',
   'E',
   'A',
   'A',
   'A',  /* Unknown -- X is unknown A.A. */
   'I',
   'W',
   'A',
   'Y',
   'E',
   'A',  /* Unknown -- X is unknown A.A. */
};
                           
#else
PARMS_EXTERN const BYTE PARMS_MergedAlphabetLookup[ALPHABETIC_CHARACTERS];
#endif

/*********************************************************************************/
/* Public Module Function Prototypes */
/*********************************************************************************/
BYTE *PARMS_GetInputFileName(void);
BYTE *PARMS_GetOutputFileName(void);
PARMS_INPUT_FILE_FORMAT PARMS_GetInputFileFormat(void);
PARMS_SEQUENCE_TYPE PARMS_GetSequenceType(void);
BOOLEAN PARMS_GetUseMergedAlphabetForDistance(void);
BOOLEAN PARMS_GetGenerateCompleteDistanceMatrix(void);
void PARMS_SetSequenceType(PARMS_SEQUENCE_TYPE SequenceType);
BOOLEAN PARMS_ProcessCommandLine(INT argc, BYTE **argv);
void PARMS_Printf(BYTE *String);
void PARMS_PrintfProgress(ULONG Current, ULONG Total);
